'www.tdpcb.com
'This will place the file name of the PCB on the board on any
'layer that is displayed.
Sub AddFileName
    Dim  Board
    Dim  ASMSting
    Dim  Layer
    Dim TmpString

    Set Board = PCBServer.GetCurrentPCBBoard
    If Board is Nothing Then Exit Sub
    PCBServer.PreProcess
    Iterator = Board.BoardIterator_Create

    For Layer = eTopLayer to eMultiLayer
        If Board.LayerIsDisplayed(Layer) AND  Board.LayerIsUsed(Layer) Then
           ASMString           = PCBServer.PCBObjectFactory(eTextObject, eNoDimension, eCreate_Default)
           ASMString.XLocation = Board.XOrigin + MilsToCoord(500) '500 mils from origin in X
           ASMString.YLocation = Board.YOrigin - MilsToCoord(500) '-500 mils from origin in Y
           TmpString = Board.FileName
           While Instr(TmpString, "\")  <> 0
            TmpString = Right(TmpString, Len(TmpString)-Instr(TmpString, "\") ) 'removes the path
           Wend
           ASMString.Text      = Left(TmpString, Instr(TmpString, ".") - 1  )   'removes the extension
           ASMString.Size      = MilsToCoord(100) 'Size of the string is 100
           ASMString.Layer     = Layer

           Board.AddPCBObject(ASMString) ' Put this string on the Board
       End If
     Next

    Pcbserver.PostProcess
    Call AddStringParameter("Action", "Redraw")
    RunProcess("PCB:Zoom")
End Sub
